<?php
ob_start();
if(!(is_readable(realpath(dirname(__FILE__)).'/include/includesroutines.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/includesroutines.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/includesroutines.inc');
}

if(!(is_readable(realpath(dirname(__FILE__)).'/include/pagination.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/pagination.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/pagination.inc');
}

checkUserAndRedirectToLogin();

if(!(is_readable(realpath(dirname(__FILE__)).'/include/filterbuttons.inc'))) {
	die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/include/filterbuttons.inc');
} else {
	include_once(realpath(dirname(__FILE__)).'/include/filterbuttons.inc');
}

$cn = db_connect();
$contlng = null;
$contlngid = null;

if (getSetting('portal','useRights',0) == 1){
	$contlng = 'lang='.db_getLanguageShortByID($cn, $_SESSION['user_idlanguagecontent']);
	$contlngid = $_SESSION['user_idlanguagecontent'];
}

$hideheader = (isset($_COOKIE['hideheader']) ?  $_COOKIE['hideheader'] : 0);
$usr_arr = (isset($usr_arr) ? $usr_arr : GetUserIDs());

if ( GetSetting('portal','useRights',0) == 0 ){
	if( !IsUserLogin() ){
		header("Location: ".getCurPageURLWO()."/businessmodel.php");
		ob_end_flush();
		exit;
	}
} else {
	if( !IsUserLogin() ){
		header("Location: ".getCurPageURLWO()."/login.php?returl=adminpollobject.php");
		ob_end_flush();
		exit;
	}
	$cn = db_connect();
	if (!isUserAdmin() && !db_isUserAdminToPolls($cn, $usr_arr)){ 
		header("Location: ".getCurPageURLWO()."/personal.php");
		ob_end_flush();
		exit;
	}
}

setCookieAdminLastPage('adminpollobject');
$polltypes = db_getPollTypesListAdmin($cn, $_SESSION['user_idlanguagecontent']);

if (getCookieForPage('firstvisit') === NULL ) {
	setCookieForPage("firstvisit", TRUE);
	setCookieForPage('filter-status-1', TRUE);
	for($i=0; $i<sizeof($polltypes); $i++){
		$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
		setCookieForPage($skpolltype, $skpolltype);
	}
	header("Location: ".getCurPageURL());
	ob_end_flush();
	exit;
}

if(sizeof($_REQUEST) == 0) {
	$urlFromCookies = getCurPageURL();
	if (getCookieForPage('filter-completed') === NULL && getCookieForPage('filter-uncompleted') === NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-uncompleted', 'filter-uncompleted');
	}
	
	if (getCookieForPage('filter-completed') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-completed', 'filter-completed');
	}
	
	if (getCookieForPage('filter-uncompleted') !== NULL ) {
		$urlFromCookies = urlReplaceParam($urlFromCookies,'filter-uncompleted', 'filter-uncompleted');
	}

	$status_arr = db_getPollsStatusList($cn);
	for($i=0; $i<sizeof($status_arr); $i++){
		$cookiesname = 'filter-status-'.$status_arr[$i]['idpollingobjectstatus'];
		if (getCookieForPage($cookiesname) !== NULL ) {
			$urlFromCookies = urlReplaceParam($urlFromCookies, $cookiesname, $cookiesname);
		}
	}

	for($i=0; $i<sizeof($polltypes); $i++){
		$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
		if (getCookieForPage($skpolltype) !== NULL ) {
			$urlFromCookies = urlReplaceParam($urlFromCookies,$skpolltype, $skpolltype);
		} else {
			$sknownpolltype = 'known-skpolltype_'.$polltypes[$i]['skpolltype'];  //63391
			if (getCookieForPage($sknownpolltype) === NULL ) {
				$urlFromCookies = urlReplaceParam($urlFromCookies,$skpolltype, $skpolltype);
			}
		}
	}
		
	if( $urlFromCookies !== getCurPageURL() ){
		header("Location: ".$urlFromCookies);
		ob_end_flush();
		exit;
	}
}

$onpage = getSetting('page', 'polls.pagesize', 20);
$default_order_column = getCookieForPage('order_column','updatedate'); 
$default_order_val = getCookieForPage('order_val','asc');

// url parse and build
$order_column = isset( $_GET[ "order_column" ] ) ? $_GET[ "order_column" ] : $default_order_column;
$order_val = isset( $_GET[ "order_val" ] ) ? $_GET[ "order_val" ] : $default_order_val;
setCookieForPage("order_column", $order_column);
setCookieForPage("order_val", $order_val);
$page = isset( $_GET[ "page" ] ) ? $_GET[ "page" ] : 1;
$usr_arr = GetUserIDs();
$url = buildTableTitleURL( $order_column, $order_val );

setCookieForPage('filter-uncompleted', NULL);
setCookieForPage('filter-completed', NULL);

if (isset($_REQUEST['filter-completed']) && isset($_REQUEST['filter-uncompleted'])){
	setCookieForPage('filter-completed', 'filter-completed');
	setCookieForPage('filter-uncompleted', 'filter-uncompleted');
} else if (isset($_REQUEST['filter-completed'])){
	setCookieForPage('filter-completed', 'filter-completed');
} else if (isset($_REQUEST['filter-uncompleted'])){
	setCookieForPage('filter-uncompleted', 'filter-uncompleted');
}

?>
<!doctype html>
<html>
<head>
	<title><?php echo renderTitle();?></title>
	<? 
	renderCommonMeta(renderTitle()); 
	renderCommonCSS(); 
	?>
</head>
<body>
	<?php renderModalHourGlassDiv();?>
	<div id="container">
		<?php renderLoginBlock();	?>
		<div id="main" role="main" class="ui-layout-center">
			<?php renderMainMenu(strtolower(pathinfo($_SERVER['PHP_SELF'], PATHINFO_FILENAME)), FALSE); ?>
				<div id="box-tabs">
					<ul class="list-tabs">
						<?php if (isUserAdmin()) { ?>
							<li><a href="admingeneral.php"><?php getResource("button.admin.general");?></a></li>
							<li><a href="admin.php"><?php getResource("button.admin.statistic");?></a></li>
							<li><a href="adminconsole.php"><?php getResource("button.admin.console");?></a></li>
						<?php } ?>
						<li class="active"><a href="#"><?php getResource("button.admin.polls");?></a></li>
					</ul>
				</div>
			</section>
			<div id="content" class="ui-layout-center">
			<section class="box-front-bottom front-menu clearfix">
				<div id="box-input-container" style="margin-bottom: 15px;">

					<div class="box-period">
						<div class="box-period-caption"><?php getResource("title.polls.progress");?></div>
						<span>
							<?php 
								echo buildFilterButton(getResourceByLang("title.polls.progress.completed"), 'filter-completed', isset($_REQUEST['filter-completed']), $order_column, $order_val, $page );
								echo buildFilterButton(getResourceByLang("title.polls.progress.uncompleted"), 'filter-uncompleted', isset($_REQUEST['filter-uncompleted']), $order_column, $order_val, $page );
							?>
						</span>
					</div>

					<div class="box-period">
						<div class="box-period-caption"><?php getResource("title.polls.type");?></div>
						<span>
							<?php
							for($i=0; $i<sizeof($polltypes); $i++){
								$skpolltype = 'filter-skpolltype_'.$polltypes[$i]['skpolltype'];
								$sknownpolltype = 'known-skpolltype_'.$polltypes[$i]['skpolltype'];  //63391
								setCookieForPage($sknownpolltype, $sknownpolltype);
								setCookieForPage($skpolltype, NULL);
								if (isset($_REQUEST[$skpolltype])) {
									setCookieForPage($skpolltype, $skpolltype);
								}	
								echo buildFilterButton(	$polltypes[$i]['name'], $skpolltype, isset($_REQUEST[$skpolltype]), $order_column, $order_val, $page, getSetting('page', 'polls.buttontype.symbolscount', 0) );
							}
							?>
					</span>
				</div>

				<div class="box-period" style="visibility: visible;margin-bottom: 15px;">
					<div class="box-period-caption" ><?php getResource("title.polls.status");?></div>
					<span>
						<?php 
							$status_arr = (isset($status_arr) ? $status_arr : db_getPollsStatusList($cn));
							for($i=0; $i<sizeof($status_arr); $i++){
								setCookieForPage('filter-status-'.$status_arr[$i]['idpollingobjectstatus'], (isset($_REQUEST['filter-status-'.$status_arr[$i]['idpollingobjectstatus']]) ? 'filter-status-'.$status_arr[$i]['idpollingobjectstatus'] : NULL));
								echo buildFilterButton(getResourceByLang("title.polls.status.".$status_arr[$i]['idpollingobjectstatus']), 'filter-status-'.$status_arr[$i]['idpollingobjectstatus'], isset($_REQUEST['filter-status-'.$status_arr[$i]['idpollingobjectstatus']]), $order_column, $order_val, $page );
							}
						?>
					</span>
				</div>
			</div>

			<div id="box-input-container" name="box-input-container">
				<div id="loadingbox" name="loadingbox" style="font-weight: bolder;padding-top: 40px;padding-bottom: 40px;"></div>
			</div>				

		</section>
	</div>

<script>window.jQuery || document.write('<script src="js/libs/jquery-1.7.1.min.js"><\/script>')</script>
<script src="js/libs/jquery.cookie.js"></script>
<script src="js/script.js"></script>
<script src="js/libs/drDialog/drdialog.js"></script>
<link rel="stylesheet" href='js/libs/drDialog/drdialog.css' />
<script src="js/dialoglinks.js"></script>
<script src="js/dotloader.js"></script>
<script src="js/adminpollobject.js"></script>
<script src="js/box-caption-processor.js"></script>
<script>
	ShowModalWindow();
	var confirmNotifyMsg = '<?php getResource("confirm.sendpollnotify");?>';
	var confirmMsg = '<?php getResource("confirm.deletepoll");?>';
	var loadingtext = '<?php getResource("title.loading");?>';
	var params = location.search;
	
	function initPollControlLinks(){
		$('.poll-status-delete-link').click(function(){
			if (confirm(confirmMsg)){
				ShowModalWindow(true);
				var url = $(this).attr('href');
				$.post(url, function( data ) {
					window.location.reload(false); 
					return false;
				});
			} else {
				ShowModalWindow(false);
			}
			return false;
		});
		$('.poll-status-change-link').click(clickOnChangeStatus);
	}

	$(function(){
		startLoadAndSwohDotsRun(loadingtext, "#loadingbox", 8, 500);

		$.ajax({
				type: "GET",
				url: ("service/adminpollobject.php" + params),
				success: function(arg){
					var msg = arg;
					if ( msg.toString().length > 0 ) {
						$("#box-input-container").append(msg);
						$( window ).resize();
						initPollControlLinks();
						initDialogLinks();
						$("a").not(".self-event").click( function() { ShowModalWindow();});					
					}
				},
				complete:function(arg){
					stopLoadAndSwohDotsRun();
					$("#loadingbox").remove();
					ShowModalWindow(false);
				}
			});	
	});

</script>
<?php
	if(!(is_readable(realpath(dirname(__FILE__)).'/templates/languagesbox.template'))) {
		die('Error - Could not open or read file '.realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	} else {
		include_once(realpath(dirname(__FILE__)).'/templates/languagesbox.template');
	}
?>
<?php renderFooterTemplate(); ?>
</body>
</html>
<?php ob_end_flush(); ?>