<?php
if(!(is_readable(realpath(dirname(__FILE__).'/../../').'/include/log.inc'))) {
        die('Error - Could not open or read file '.realpath(dirname(__FILE__).'/../../').'/include/log.inc');
} else {
        include_once(realpath(dirname(__FILE__).'/../../').'/include/log.inc');
}

function logError($cn, $query){
        if ((!(null === mysqli_error($cn)) && mysqli_errno($cn) > 0)) {
                logmessage("Query -  ".$query);
                logmessage("Error - ".mysqli_errno($cn));
                logmessage(mysqli_error($cn));
				return true;
        }
		return false;
}

function db_connect(){
        if (getSetting('database','port', -1) != -1){
                $cn = mysqli_connect(GetSetting('database','uri',''), GetSetting('database','userLogin',''), GetSetting('database','userPassword',''), GetSetting('database','database',''), GetSetting('database','port',''));
        } else {
                $cn = mysqli_connect(GetSetting('database','uri',''), GetSetting('database','userLogin',''), GetSetting('database','userPassword',''), GetSetting('database','database',''));
        }

        if (mysqli_connect_errno()) {
                die ("Error db connect - ".mysqli_connect_errno()." ".mysqli_connect_error());
                exit();
        }
        ini_set('mysql.connect_timeout', 6000);
        ini_set('default_socket_timeout', 6000);
        set_time_limit(0);
        $cn->query('SET NAMES utf8');        
		$cn->set_charset('utf8');
        $cn->query("SET collation_connection = utf8mb4_general_ci");
        logError($cn, "");
        return $cn;
}

function db_disconnect($cn){
        if ($cn !== null){
                $cn->close();
                unset($cn);
        }
}

function db_runQuery($cn, $query, $procedureName = NULL,  $debug = FALSE){
        try {
			if ($debug){
                                $starttime = microtime(true);
        			$cn->query($query);			
                                $endtime = microtime(true);
                                $duration = $endtime - $starttime;
				echo "<br><br>".$query."<br><br>".date("Y-m-d H:i:s")."<br><br> duration ".$duration."<br><br>"."<br><br>";
			} else {
                                $cn->query($query);			
                        }
			return (!logError($cn, $query));
        } catch (Exception $e) {
                if ($procedureName && strlen($procedureName) > 0 ){
                        logmessage("Procedure - ".$procedureName);
                }
                logmessage("Query - ".$query);
                logmessage("Error -  ".$e->getMessage());
		return false;
        }
}

function db_runQueryAndReturnArray($cn, $query, $procedureName = NULL){
        $resarr = array();
        try {
                $result = $cn->query($query);
                if ($result) {
                        while ($row = $result->fetch_assoc()) {
                                array_push($resarr, $row);
                        }
                }
                logError($cn, $query);
        } catch (Exception $e) {
                if ($procedureName && strlen($procedureName) > 0 )
                        logmessage("Procedure - ".$procedureName);
                logmessage("Query -  ".$query);
                logmessage("Error - ".$e->getMessage());
                $resarr = array(0 => array(0 => ''));
        }
        return $resarr;
}

?>