$(document).ready(function () {
    function addStepInURL(){
        var u = new Url;

        if (u.query["reportInHistory"]) {
            delete u.query["reportInHistory"];
        }

        if (u.query["step"]) {
            u.query.step = parseInt(u.query.step) + 1;
        } else {
            u.query.step = 1;
        }

        if (supportHistoryApi()) {
            history.pushState(null, '', u);
        }
    }

    var outerLayout;
    var topLayout;
    var layoutSettings_Outer = {
        fxName: "none",
        spacing_open: 4,
        spacing_closed: 0,
        togglerLength_open: 0,
        togglerLength_closed: 0,
        resizerClass : (isMobileMode && isMobileMode == 1 ? "ui-layout-resizer-mobile" : "ui-layout-resizer"),
        maskIframesOnResize: false,
        name: "outerLayout",
        defaults: { contentSelector: ".content" },
        north: {
            size: (getIsMenuWide() ? 70 : 40),
            spacing_open: 0,
            spacing_closed: 0,
            togglerLength_open: 0,
            togglerLength_closed: -1,
            resizable: false,
            slidable: false
        },
        east: {
            initHidden : ((isMobileMode && isMobileMode == 1) ? (mobileViewReport ? true : false) : false),
            size: oRSize,
            minSize: (isMobileMode && isMobileMode == 1 ? 0 : 370),
            resizable: (isMobileMode && isMobileMode == 1 ? false : true),
            closable: (isMobileMode && isMobileMode == 1 ? false : true),
            slidable: (isMobileMode && isMobileMode == 1 ? true : false),
            onresize: function () {
                $('iframe#iframe-sub-doc').height($('#box-layout-east-container').height());
                $('iframe#iframe-sub-doc').width($('#box-layout-east-container').width()); 
                outerLayout = $("#main").layout(layoutSettings_Outer);
                $( window ).resize();
                if (typeof isMobileMode == "undefined" || isMobileMode != 1) {
                    $.ajax({
                        url: "layoutcookies.php?page=pollobject&east=" + outerLayout.state.east.size,
                        success: function (response) {
                            var r = response; r = null; 
                        }
                    });
                }
            },
            onclose_start: function () {
                existUnsavedData = (existUnsavedData ? !confirm(gConfirmsavelesValue) : existUnsavedData);
                return !existUnsavedData;
            },
            onclose: function () {
                $('#box-frame').removeClass('box-frame-wide').addClass('box-frame-padding');	
                $('#box-frame-header-right').addClass('box-frame-header-right-wide');	
                $('#btn-review-open').removeClass('btn-vertical-right-select').removeClass('btn-vertical-right-unselect').addClass('btn-vertical-right');
                $('#btn-discussion-open').removeClass('btn-vertical-right-select').removeClass('btn-vertical-right-unselect').addClass('btn-vertical-right');
                $('#container').layout().resizeAll();
                toggleMobileView();
                if (typeof isMobileMode === "undefined" || isMobileMode != 1) {
                    $.ajax({
                        url: "layoutcookies.php?page=pollobject&east_hide=1",
                        success: function (response) {
                            var r = response; r = null; 
                        }
                    });
                }                
            },
            onopen: function () {
                $('#box-frame').removeClass('box-frame-padding').addClass('box-frame-wide');	
                $('#box-frame-header-right').removeClass('box-frame-header-right-wide');	
                $('#container').layout().resizeAll();
                if (typeof isMobileMode === "undefined" || isMobileMode != 1) {
                    $.ajax({
                        url: "layoutcookies.php?page=pollobject&east_hide=0",
                        success: function (response) {
                            var r = response; r = null; 
                        }
                    });
                }
            }
        },
        west: {
            initHidden : true
        },
        center: {
            initHidden : ((isMobileMode && isMobileMode == 1) ? (!mobileViewReport ? true : false) : false),
            minWidth: (isMobileMode && isMobileMode == 1 ? 0 : 450),
            onresize: "innerLayout.resizeAll"
        }
    };

    var layoutSettings_Top = {
        fxName: "none",
        spacing_open: 0,
        spacing_closed: 0,
        togglerLength_open: 0,
        togglerLength_closed: 0,
        maskIframesOnResize: false,
        name: "topLayout",
        defaults: {
        },
        north: {
            size: ($.cookie('hideheader') == 1 ? 0 : 74),
            spacing_open: 2,
            spacing_closed: 2,
            togglerLength_open: 0,
            togglerLength_closed: 0,
            resizable: false,
            slidable: false,
            onclose: function () {
                $("#btn-toggle-header").addClass("closed");
                $("#btn-toggle-header").blur();
                $.ajax({
                    url: "hideheader.php?hheader=1",
                    success: function (response) {
                    }
                });

            },
            onopen: function () {
                $("#btn-toggle-header").removeClass("closed");
                $("#btn-toggle-header").blur();
                $.ajax({
                    url: "hideheader.php?hheader=0",
                    success: function (response) {
                    }
                });
            }
        }
    };

    topLayout = $('#container').layout(layoutSettings_Top);
    $("#btn-toggle-header").show();
    $("#main").css("padding-left", "20px");
    $("#box-menu").css("padding-left", "0px");


    if (isMobileMode && isMobileMode == 1) {
        $("#main").css("padding-right", "20px");
        $("#box-menu").css("padding-right", "0px");
        $("#box-frame").css("padding-right", "0px");
        $('#btn-review-open').removeClass('btn-vertical-right-select').removeClass('btn-vertical-right-unselect').addClass('btn-vertical-right');
        $('#btn-discussion-open').removeClass('btn-vertical-right-select').removeClass('btn-vertical-right-unselect').addClass('btn-vertical-right');        
        mobileViewReport = false;
        toggleMobileView();
    } else {
        outerLayout = $("#main").layout(layoutSettings_Outer);
    }

    function toggleMobileView(){
        if (isMobileMode != 1) {
            return;
        }
        outerLayout = $("#main").layout(layoutSettings_Outer);
        outerLayout.options.stateManagement.autoSave = false;
        if (mobileViewReport){
            mobileViewReport = false;
            $('#box-frame').hide();
            outerLayout.show("east");
            $("#box-layout-east-title").click(function(){
                outerLayout.hide("east");
            });
            startResize();
            $(window).resize();
        } else {
            mobileViewReport = true;
            $('#box-frame').show();
            outerLayout.hide("east");
            $("#box-frame-header-right").removeClass("box-frame-header-right-wide").addClass("box-frame-header-right-wide-mobile");
            endResize();
        }
    } 
        
    function resizer() {
        var p = $("#box-layout-east");
        var offset = p.offset();
        $(p).offset({ top: offset.top, left: 20});
        $("#box-layout-east").width($( "#box-poll-bread-crumbs" ).width());
    }

    function startResize() {
        $(window).resize(resizer);
    }

    function endResize() {
        $(window).off("resize", resizer);
    }

    $( "#btn-review-open" ).click(function() {
        if (isMobileMode && isMobileMode == 1 && mobileViewReport && !existUnsavedData) {
            toggleMobileView();
        }
	});

    $( "#btn-discussion-open" ).click(function() {
        if (isMobileMode && isMobileMode == 1 && mobileViewReport && !existUnsavedData) {
            toggleMobileView();
        }
    });

    if ($("#box-layout-east > header").length){
        outerLayout.addCloseBtn("#box-layout-east > header", "east");
    } 

    if ($("#btn-discussion-open").length){
        outerLayout.addOpenBtn("#btn-discussion-open", "east");
    } 

    if ($("#btn-review-open").length){
        outerLayout.addOpenBtn("#btn-review-open", "east");
    } 
 
    if (eastHide && eastHide == 1) {
        outerLayout.close("east");
    }
    if (docName)
        loadDoc(docName);

    $('iframe#iframe-doc').ready(function () {
        var innerLayout;

        var layoutSettings_Inner = {
            fxName: "none",
            spacing_open: 0,
            spacing_closed: 0,
            togglerLength_open: 0,
            togglerLength_closed: 0,
            name: "innerLayout",
            defaults: { contentSelector: ".content" },
            north: {
                size: 30,
                spacing_open: 2,
                spacing_closed: 2,
                togglerLength_open: 0,
                togglerLength_closed: 0,
                resizable: false,
                slidable: false
            }
        };
        innerLayout = $('#box-frame').layout(layoutSettings_Inner);

        var u = new Url;
        u.query.reportInHistory = true;

        if (supportHistoryApi()) {
            history.replaceState(null, '', u);
        }
    });

    $('iframe#iframe-doc').load(function () {
        $("#box-frame-header-right").show();
        if (!isMobileMode || isMobileMode != 1) $("#header-pane-north").css("right","0");

        $("iframe#iframe-doc").css("background-image", "none");
        if (/iPhone|iPod|iPad/.test(navigator.userAgent)) {
            $('#box-iframe').css({ height: "4000px", overflow: 'auto', '-webkit-overflow-scrolling': 'touch' });
            $('#iframe-doc').css({ height: "4000px", overflow: 'auto', '-webkit-overflow-scrolling': 'touch' });
        };
        var reportName = "";
        if ($('#cmreports').is(':visible')) {
            reportName = $("#cmreports option:selected").text();
        }

        ShowModalWindow(false);
    });

    if ($('#btn-review-open').length){
        $("#btn-review-open").css({ top: ($("#box-frame").offset().top + 34) + 'px' });
        $("#btn-discussion-open").css({ top: ($("#box-frame").offset().top + 34 + $("#btn-review-open").height() ) + 'px' });   
    } else {
        $("#btn-discussion-open").css({ top: ($("#box-frame").offset().top + 34) + 'px' });   
    }
    $('#btn-review-open').show();
    $('#btn-discussion-open').show();

    var module = document.getElementById("box-poll-bread-crumbs-text");
    $clamp(module, {clamp: 2});
    $("#box-poll-bread-crumbs").show();

});


