<?php
ob_start();

if(!(is_readable(realpath(dirname(__FILE__).'/../')."/include/loginroutines.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__).'/../')."/include/loginroutines.inc");
} else {
	include_once(realpath(dirname(__FILE__).'/../')."/include/loginroutines.inc");
}

// параметр фасад передается как часть пути
if(!(is_readable(realpath(dirname(__FILE__).'/../')."/include/db/mysqlroutines.common.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__).'/../')."/include/db/mysqlroutines.common.inc");
} else {
	include_once(realpath(dirname(__FILE__).'/../')."/include/db/mysqlroutines.common.inc");
}

if(!(is_readable(realpath(dirname(__FILE__).'/../')."/include/translate.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__).'/../')."/include/translate.inc");
} else {
	include_once(realpath(dirname(__FILE__).'/../')."/include/translate.inc");
}

if(!(is_readable(realpath(dirname(__FILE__).'/../')."/include/content.inc"))) {
	die("Error - Could not open or read file ".realpath(dirname(__FILE__).'/../')."/include/content.inc");
} else {
	include_once(realpath(dirname(__FILE__).'/../')."/include/content.inc");
}

if ( GetSetting('portal','useRights',0) == 1 && !IsUserLogin()){
	ob_end_flush();
	exit;
}
if (!isset($_SESSION['user_idlanguagecontent'])){
	checkLanguage();
}

$cn = db_connect();
if (isset($_REQUEST['idbranch'])) {
	$idbranch = $_REQUEST['idbranch'];
	$skbranch = db_getSKBranch($cn,$idbranch);	
} else if (isset($_REQUEST['skbranch'])) {
	$isBranchSet = true;
	$skbranch = $_REQUEST['skbranch'];
	$idbranch = db_getIDBranch($cn, $skbranch );	
} else {
	$skbranch = db_getMainSKBranch($cn);
	$idbranch = db_getMainIDBranch($cn);	
}

$user_idlanguagecontent = $_SESSION['user_idlanguagecontent'];
session_write_close();

$tr_arr = db_getObjectTreetoUser($cn, (isset($_REQUEST['root']) ? $_REQUEST['root'] : 0), GetUserIDs(), $user_idlanguagecontent, $skbranch);
if ( getSetting('portal','useRights',0) == 1) {		
	$rghmap = db_getObjectTreeMaptoUser($cn,GetUserIDs(), $skbranch);		
}
echo '[ ';
$_cnt = 0;

foreach ($tr_arr as $node) {
	echo $_cnt == 0 ? '{' : ',{ ';
	echo '"text": "'.nl2br(str_replace('"', "&quot;", str_replace('\\', "&frasr;", $node['o_name']))).'",';
	echo '"icon":  "'.$node['o_icon'].'",';
	echo '"expanded": false, ';
	echo '"name": "'.str_replace('"', "&quot;", $node['o_guid']).'",';
	echo '"id": "'.$node['idobject'].'",';
	if ( getSetting('portal','useRights',0) == 1) {
		$size = (is_array($rghmap) ?  sizeof($rghmap) : 0 );
		$hasChildren = FALSE;
		for($i=0; $i<$size; $i++){
			if ($rghmap[$i]['parent_idobject'] == $node['idobject']) {
				$hasChildren = TRUE;
				break;
			}
		}
	} else {
		$hasChildren = ($node['o_iright'] - $node['o_ileft'] > 1);
	}
	echo '"hasChildren": '.($hasChildren ? 'true' : 'false');
	echo '} ';
	$_cnt = $_cnt + 1;
}
echo '] ';
db_disconnect($cn);
ob_end_flush();
?>
